#ifndef HARDWARE_PROFILE_H
#define HARDWARE_PROFILE_H

	// Defines required for the USB stack
    #define self_power          1
    #define USE_USB_BUS_SENSE_IO
	#define USB_BUS_SENSE       1
    #define DEMO_BOARD PICDEM_FS_USB
    #define PICDEM_FS_USB
    #define CLOCK_FREQ 48000000

	// Fosc frequency (48 Mhz)
	#define _XTAL_FREQ 48000000
	
	// Common useful definitions
	#define ON		1
	#define OFF		0
	#define	WRITE	0
	#define READ	1
	#define SEG0L	0
	#define SEG1L	1
	#define SEG2L	2
	#define SEG3L	3
	#define SEG4L	4
	#define SEG5L	0b00010010
	#define SEG6L	0b00000010
	#define SEG7L	0b01111000
	#define SEG8L	0b00000000
	#define SEG9L	0b00010000

	// PIC to hardware pin mapping
	#define LED0	RE0
	#define LED1	RE1
	#define LED2	RE2
	#define SWITCH0	RC1
	#define Enable	RB6
	#define CA2SEG	RE1
	#define CA3SEG	RE2
	#define	DIG_ADD	RD7
	#define	MOD_SEL1	RD6
	#define	MOD_SEL2	RD5

    // I/O pin definitions
    #define INPUT_PIN 1
    #define OUTPUT_PIN 0

#endif
